<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use Mattiverse\Userstamps\Traits\Userstamps;
use Illuminate\Database\Eloquent\SoftDeletes;

class Seguimiento extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use SoftDeletes, Userstamps;
    
    protected $fillable = [
        'proceso_id',
        'fecha_seguimiento',
        'estado_id',
        'observacion',
        'adjunto'
    ];

    public function proceso()
    {
        return $this->belongsTo(Proceso::class);
    }
    public function usuario()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
    public function estado()
    {
        return $this->belongsTo(Parametro::class, 'estado_id', 'id');
    }
}
