<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('procesos', function (Blueprint $table) {
            $table->id();
            $table->integer('numero_proceso');
            $table->string('codigo_proceso');
            $table->string('numero_nurej')->unique();
            $table->text('parte_demandante');
            $table->string('nombre_proceso');
            $table->string('delito')->nullable();
            $table->foreignId('tipo_proceso_id')->constrained('parametros');
            $table->date('fecha_inicio');
            $table->boolean('estado')->default(true);
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('procesos');
    }
};
