<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('audiencias', function (Blueprint $table) {
            $table->id();
            $table->foreignId('proceso_id')->constrained('procesos');
            $table->string('departamento');
            $table->foreignId('tipo_audiencia_id')->constrained('parametros');
            $table->date('fecha_audiencia');
            $table->time('hora_audiencia');
            $table->string('lugar')->nullable();
            $table->string('juzgado')->nullable();
            $table->string('sala')->nullable();
            $table->string('representantes')->comment('Abogados que asistirán a la audiencia, nombres separados por coma')->nullable();
            $table->foreignId('estado_id')->constrained('parametros');
            $table->text('observaciones')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('audiencias');
    }
};
