
@extends('layouts.app')
@section('title','Editar Rol')
@section('content')

<div class="main-content-inner">
    <div class="row">
        <div class="col-xl-9 col-lg-8">
            <div class="card">
                <div class="card-body">
                    {!! Form::model($role,['route'=>['roles.update',$role->id],'method'=>'PUT']) !!}
                        @include('admin.roles._form')
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('scripts')
<script>
    $(document).ready(function() {
        $('.marcar-todos').click(function() {
            var grupoId = $(this).data('grupo');
            var checked = $(this).prop('checked');
            $('input[type="checkbox"][data-grupo="' + grupoId + '"]').prop('checked', checked);
                // Detectar elementos marcados y mostrar el acordeón
                updateSelectedCount(grupoId);
        });
    });
    function updateSelectedCount(grupoId) {
        var checkedCount = $('input[type="checkbox" ][data-grupo="' + grupoId + '"]:checked').length;
        var totalCount = $('input[type="checkbox"][data-grupo="' + grupoId + '"]').length;
        totalCount=totalCount-1;        
        $('#contador-' + grupoId).html(checkedCount + ' de ' + totalCount  + ' seleccionados');
    }
    $('input[type="checkbox"]').change(function() {
        var grupoId = $(this).data('grupo');
        updateSelectedCount(grupoId);
    });
     // Inicializar contadores
     $('[data-grupo]').each(function() {
        var grupoId = $(this).data('grupo');
        updateSelectedCount(grupoId);
    });
  </script>
@endSection

