@extends('layouts.app')
@section('title','Permisos de Rol')
@section('content')
<div class="page-title-area mb-3">
    <div class="row align-items-center">
        <div class="col-sm-6">
            <div class="breadcrumbs-area clearfix">
                <h4 class="page-title pull-left">Roles</h4>
                <ul class="breadcrumbs pull-left">
                    <li><a href="{{ route('roles.index') }}">Seguridad</a></li>
                    <li><span>Permisos asignados</span></li>
                </ul>
            </div>
        </div>
    </div>
</div>
<div class="main-content-inner">
    <div class="row">
        <div class="col-xl-9 col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h4>{{ $role->name }}</h4>
                    <a href="{{route('roles.index')}}" class="btn btn-warning btn-round">Salir</a>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        @foreach($permissions as $permission)
                            <li>
                                <label>
                                    <strong>{{$permission->descripcion ?: 'Sin descripción'}}</strong>
                                </label>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection