@extends('layouts.app')
@section('titulo','Usuarios')
@section('content')

<div class="main-content-inner">
    <div class="row">
        <div class="col-xl-12 col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4>Listado de Usuarios</h4>
                     @can('users.create')<a href="{{ route('users.create') }}" class="btn btn-primary btn-round mr-2">Agregar Nuevo</a>@endcan
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                    <table width="100%" id="datos" class="table table-hover table-sm">
                        <thead>
                            <tr>
                                <th class="text-center">Acciones</th>
                                <th class="text-center">Nombre Completo</th>
                                <th class="text-center">Nombre de Usuario</th>
                                <th class="text-center">Correo</th>
                                <th class="text-center">Rol Asignado</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($users as $user)
                            {{-- @if($user->id != 1 && $user->id != auth()->user()->id) --}}
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center justify-content-center">
                                            @can('users.edit')
                                                <a href="{{route('users.edit',$user->id)}}" title="Modificar datos"><button class="btn btn-warning btn-icon btn-sm "><i class="fa fa-edit"></i></button></a>
                                            @endcan
                                            @can('users.destroy')
                                                <form action="{{ route('users.destroy', $user->id) }}" method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="button" class="btn btn-danger btn-icon btn-sm btn-delete-user" 
                                                        data-id="{{ $user->id }}" 
                                                        data-name="{{ $user->name }}" title="Eliminar Usuario">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </form>
                                            @endcan
                                        </div>
                                    </td>
                                    <td>{{$user->name}}</td>
                                    <td class="text-center">{{$user->username}}</td>
                                    <td class="text-center">{{$user->email}}</td>
                                    <td class="text-center">
                                        @foreach ($user->roles as $rol )
                                            <strong>{{$rol->name}}</strong>
                                        @endforeach
                                    </td>
                                </tr>
                            {{-- @endif --}}
                            @endforeach
                        </tbody>
                    </table>
                </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('scripts')
<script src="{{asset('assets/js/tablas/basica.js')}}"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>

    document.addEventListener('DOMContentLoaded', function () {

    document.querySelectorAll('.btn-delete-user').forEach(button => {
        button.addEventListener('click', function () {

            let form = this.closest('form');
            let userName = this.dataset.name ?? 'este usuario';

            Swal.fire({
                title: '¿Está seguro?',
                text: "Se eliminará definitivamente " + userName,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        });
    });

});
</script>
@endsection