@extends('layouts.app')
@section('title','Mis Datos')
@section('content')

<div class="page-header">
    <div class="page-block">
        <div class="row align-items-center">
            <div class="col-md-12">
                <div class="page-header-title">
                    <h5>Mis Datos</h5>
                </div>
                <ul class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}"><i class="feather icon-home"></i></a></li>
                    <li class="breadcrumb-item"><a href="#!">Mis Datos</a></li>
                </ul>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-4">
        <div class="card">
            <div class="card-body text-center">
                <div class="usre-image">
                    <img src="{{ asset('assets/images/auth/'.auth()->user()->avatar) }}" class="img-radius wid-100 m-auto" alt="User-Profile-Image">
                </div>
                <h6 class="f-w-600 m-t-25 m-b-10">{{ auth()->user()->name }}</h6>
            </div>
          </div>
    </div>
    <div class="col-sm-8">
        <ul class="nav nav-tabs" id="myTab" role="tablist">
            <li class="nav-item">
                <a class="nav-link text-uppercase @if (count($errors)==0)active @endif" id="mis-datos" data-toggle="tab" href="#misDatos" role="tab" aria-controls="misDatos" aria-selected="true">información General</a>
            </li>
            <li class="nav-item">
                <a class="nav-link text-uppercase @if($errors->hasAny(['name', 'username','avatar'])) active @endif" id="modificarDatos" data-toggle="tab" href="#editDatos" role="tab" aria-controls="editDatos" aria-selected="false">MODIFICAR DATOS</a>
            </li>
            <li class="nav-item">
                <a class="nav-link text-uppercase @if($errors->hasAny(['current_password','password', 'password_confirmation','validation.password','new_password'])) active @endif" id="contraseña" data-toggle="tab" href="#cambiarContraseña" role="tab" aria-controls="cambiarContraseña" aria-selected="false">CAMBIAR CONTRASEÑA</a>
            </li>
        </ul>
        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade @if( count($errors)==0 ) show active @endif" id="misDatos" role="tabpanel" aria-labelledby="mis-datos">
                <div class="row mt-3">
                    <div class="col-md-6">
                        <div class="form-group form-group-default">
                            <label class="text-primary text-uppercase">Nombre</label>
                            <div class="">@if($user->empleado_id == null) {{ $user->name }} @else {{ $user->empleado->nombre }} @endif</div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group form-group-default">
                            <label class="text-primary text-uppercase">Nombre de Usuario</label>
                            <div>{{ $user->username }}</div>
                        </div>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-md-12">
                        <div class="form-group form-group-default">
                            <label class="text-primary text-uppercase">Rod asignado</label>
                            <div>{{ $user->rol[0]->name }}</div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade @if($errors->hasAny(['name', 'username','avatar'])) show active @endif" id="editDatos" role="tabpanel" aria-labelledby="modificarDatos">
                {!! Form::model($user,['route'=>['users.update_profile',$user->id],'method'=>'PUT','enctype'=>"multipart/form-data"]) !!}
                    <p>Puede ingresar los nuevos valores para el nombre completo o email y presionar el botón <strong>GUARDAR</strong> para que se guarde en el sistema. El correo electronico permite acceder al sistema.</p>
                    @if ($errors->hasAny(['name', 'username','avatar']))
                        <h5 class="text-danger">ERRORES POR CORREGIR:</h5>
                        <ul class="list-ticked">
                            @foreach ($errors->all() as $error)
                                <li class="text-danger">{{ $error }}</li>
                            @endforeach
                        </ul>
                    @endif
                    <div class="row mb-3">
                        <label for="profileImage" class="col-md-4 col-form-label text-right">Foto de Perfil</label>
                        <div class="d-flex align-items-center justify-content-center">
                            <div class="avatar avatar-xl">
                                <img src="{{ asset('assets/images/auth/'.auth()->user()->avatar) }}" alt="Profile" id="imagen" class="img-radius wid-100 m-auto">
                            </div>
                            <div class="pt-2">
                                <label for="fileInput" class="btn btn-warning btn-round btn-icon" title="Cambiar Foto">
                                    <i class="fas fa-upload"></i>
                                </label>
                                <input type="file" id="fileInput" name="avatar" style="display: none;" accept="image/*">
                            </div>
                        </div>
                    </div>
                    <div class="row mb-1 {{ $errors->has('name') ? 'has-error' : '' }}">
                        <label for="name" class="col-md-4  col-form-label text-right">Nombre Completo: <span class="text-danger">(*)</span></label>
                        <div class="col-md-6">
                            <input id="name" type="text" class="form-control" name="name" value="{{ old('name',$user->name) }}"  autofocus onkeyup="javascript:this.value=this.value.toUpperCase();" >
                        </div>
                    </div>
                    <div class="row mb-1 {{ $errors->has('name') ? 'has-error' : '' }}">
                        <label for="username" class="col-md-4 col-form-label text-right ">Nombre de usuario <span class="text-danger">(*)</span></label>
                        <div class="col-md-6">
                            <input id="username" type="username" class="form-control" name="username" value="{{ old('username',$user->username) }}" >
                        </div>
                    </div>
                    <div class="text-center mt-2">
                        <button type="submit" class="btn btn-primary btn-round">Guardar Cambios</button>
                    </div>
                {!! Form::close() !!}
            </div>
            <div class="tab-pane fade @if($errors->hasAny(['current_password','password', 'password_confirmation','validation.password','new_password'])) show active @endif" id="cambiarContraseña" role="tabpanel" aria-labelledby="contraseña">
                @if ($errors->hasAny(['current_password','password', 'password_confirmation','new_password','validation.password']))
                    <h5 class="text-danger">ERRORES POR CORREGIR:</h5>
                    <ul class="list-ticked">
                        @foreach ($errors->all() as $error)
                            <li class="text-danger">{{ $error }}</li>
                        @endforeach
                    </ul>
                @endif
                <form method="POST" action="{{ route('change.password') }}">
                    @csrf
                    <p >La nueva contraseña debe tener al menos 8 caracteres, mayúsculas, minúsculas, números y simbolos</p>
                    <div class="row mb-3 {{ $errors->has('current_password') ? 'has-error' : '' }}">
                        <label for="current_password" class="col-md-4 col-lg-3 col-form-label">Contraseña Actual</label>
                        <div class="col-md-8 col-lg-9">
                            <input name="current_password" type="password" class="form-control" id="current_password">
                        </div>
                    </div>
                    <div class="row mb-3 {{ $errors->has('new_password') ? 'has-error' : '' }}">
                        <label for="new_password" class="col-md-4 col-lg-3 col-form-label">Nueva Constraseña</label>
                        <div class="col-md-8 col-lg-9">
                            <input name="new_password" type="password" class="form-control" id="new_password">
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="renewPassword" class="col-md-4 col-lg-3 col-form-label">Confirmar Nueva Constraseña</label>
                        <div class="col-md-8 col-lg-9">
                            <input type="password" name="new_password_confirmation" id="new_password_confirmation" class="form-control" >
                            <small id="passwordHelpBlock" class="form-text text-muted">
                                <span id="passwordMatch"></span>
                            </small>
                        </div>
                    </div>
                    <div class="text-center">
                        <button type="submit" class="btn btn-primary btn-round">Cambiar Contraseña</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


@endsection
@section('scripts')

<script src="{{ asset('assets/js/forms/users.js') }}" type="text/javascript"></script>
<script>
  $(document).ready(function () {
      $('#new_password, #new_password_confirmation').on('input', function () {
          if ($('#new_password').val() == $('#new_password_confirmation').val()) {
              $('#passwordMatch').html('Las contraseñas coinciden').css('color', 'green');
          } else {
              $('#passwordMatch').html('Las contraseñas no coinciden').css('color', 'red');
          }
      });
  });
</script>
@endSection