@csrf
<p>Debe completar todos los campos.</p>
@if($errors->any())
    <div class="alert alert-outline-danger">
        <strong>Debe corregir los siguientes errores:</strong>
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
<div class="row">
    <div class="col-md-4">
        <label>Proceso Judicial</label>
        <select name="proceso_id" class="js-example-basic-single @error('proceso_id') is-invalid @enderror" data-ruta="{{ route('datos_proceso') }}" id="proceso_id" >
            <option value="">--SELECCIONE--</option>
            @foreach($procesos as $proceso)
                <option value="{{ $proceso->id }}"
                    @selected(old('proceso_id',$audiencia->proceso_id ?? '')==$proceso->id)>
                    {{ $proceso->codigo_proceso }} - {{ $proceso->nombre_proceso }}
                </option>
            @endforeach
        </select>
        @error('proceso_id')
            <span class="invalid-feedback" role="alert"></span>
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>
    <div class="col-md-4">
        <label>Partes</label>
        <input type="text" id="partes" class="form-control" readonly>
    </div>
    <div class="col-md-4">
        <label>Delito</label>
        <input type="text" id="delito" class="form-control" readonly>
    </div>
</div>
<div class="row mt-2">
    <div class="col-md-2">
        <label>Departamento</label>
        <select name="departamento" id="departamento" class="form-select @error('departamento') is-invalid @enderror">
            <option value="">--SELECCIONE--</option>
            <option value="CHUQUISACA" {{ old('departamento', $audiencia->departamento ?? '') == 'CHUQUISACA' ? 'selected' : '' }}>CHUQUISACA</option>
            <option value="LA PAZ" {{ old('departamento', $audiencia->departamento ?? '') == 'LA PAZ' ? 'selected' : '' }}>LA PAZ</option>
            <option value="COCHABAMBA" {{ old('departamento', $audiencia->departamento ?? '') == 'COCHABAMBA' ? 'selected' : '' }}>COCHABAMBA</option>
            <option value="ORURO" {{ old('departamento', $audiencia->departamento ?? '') == 'ORURO' ? 'selected' : '' }}>ORURO</option>
            <option value="POTOSI" {{ old('departamento', $audiencia->departamento ?? '') == 'POTOSI' ? 'selected' : '' }}>POTOSI</option>
            <option value="TARIJA" {{ old('departamento', $audiencia->departamento ?? '') == 'TARIJA' ? 'selected' : '' }}>TARIJA</option>
            <option value="SANTA CRUZ" {{ old('departamento', $audiencia->departamento ?? '') == 'SANTA CRUZ' ? 'selected' : '' }}>SANTA CRUZ</option>
            <option value="BENI" {{ old('departamento', $audiencia->departamento ?? '') == 'BENI' ? 'selected' : '' }}>BENI</option>
            <option value="PANDO" {{ old('departamento', $audiencia->departamento ?? '') == 'PANDO' ? 'selected' : '' }}>PANDO</option>
        </select>
        @error('departamento')
            <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>
    <div class="col-md-4">
        <label>Lugar</label>
        <input type="text" name="lugar" class="form-control @error('lugar') is-invalid @enderror" value="{{ old('lugar',$audiencia->lugar ?? '') }}">
        @error('lugar')
            <span class="invalid-feedback" role="alert"></span>
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>

    <div class="col-md-3">
        <label>Juzgado</label>
        <input type="text" name="juzgado" class="form-control @error('juzgado') is-invalid @enderror" value="{{ old('juzgado',$audiencia->juzgado ?? '') }}">
        @error('juzgado')
            <span class="invalid-feedback" role="alert"></span>
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>
    <div class="col-md-3">
        <label>Sala</label>
        <input type="text" name="sala" class="form-control @error('sala') is-invalid @enderror" value="{{ old('sala',$audiencia->sala ?? '') }}">
        @error('sala')
            <span class="invalid-feedback" role="alert"></span> 
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>
</div>
<div class="row mt-2">
    <div class="col-md-6">
        <label>Tipo de Audiencia</label>
        <select name="tipo_audiencia_id" class="form-select @error('tipo_audiencia_id') is-invalid @enderror">
            <option value="">--SELECCIONE--</option>
            @foreach($tipo_audiencias as $tipo)
                <option value="{{ $tipo->id }}"
                    @selected(old('tipo_audiencia_id',$audiencia->tipo_audiencia_id ?? '')==$tipo->id)>
                    {{ $tipo->nombre }}
                </option>
            @endforeach
        </select>
        @error('tipo_audiencia_id')
            <span class="invalid-feedback" role="alert"></span>
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>
</div>

<div class="row mt-2">
    <div class="col-md-2">
        <label>Fecha</label>
        <input type="date" name="fecha_audiencia" class="form-control @error('fecha_audiencia') is-invalid @enderror" value="{{ old('fecha_audiencia',$audiencia->fecha_audiencia ?? '') }}">
        @error('fecha_audiencia')
            <span class="invalid-feedback" role="alert"></span>
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>

    <div class="col-md-2">
        <label>Hora</label>
        <input type="time" name="hora_audiencia" class="form-control @error('hora_audiencia') is-invalid @enderror" value="{{ old('hora_audiencia',$audiencia->hora_audiencia ?? '') }}">
        @error('hora_audiencia')
            <span class="invalid-feedback" role="alert"></span>
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>
    <div class="col-md-4">
        <label>Estado</label>
        <select name="estado" class="form-select @error('estado') is-invalid @enderror">
            <option value="">--SELECCIONE--</option>
            @foreach($estados as $estado)
                <option value="{{ $estado->id }}"
                    @selected(old('estado',$audiencia->estado_id ?? '')==$estado->id)>
                    {{ $estado->nombre }}
                </option>
            @endforeach
        </select>
        @error('estado')
            <span class="invalid-feedback" role="alert"></span>
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>

    <div class="col-md-4">
        <label>Abogado Responsable</label>
        @php
            $abogadosSeleccionados = old(
                'abogado_id',
                isset($audiencia) ? explode(';', $audiencia->representantes) : []
            );
        @endphp
        <select name="abogado_id[]" class="js-example-basic-multiple @error('abogado_id') is-invalid @enderror" multiple>
            @foreach($abogados as $abogado)
                <option value="{{ $abogado->id }}"
                    {{ in_array($abogado->id, $abogadosSeleccionados) ? 'selected' : '' }}>
                    {{ $abogado->name }}
                </option>
            @endforeach
        </select>
        @error('abogado_id')
            <span class="invalid-feedback" role="alert"></span>
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>
</div>

<div class="row mt-2">
    <div class="col-md-12">
        <label>Observaciones</label>
        <textarea name="observaciones" class="form-control">{{ old('observaciones',$audiencia->observaciones ?? '') }}</textarea>
    </div>
</div>

<div class="text-center">
    <button class="btn btn-success mt-3">Guardar</button>
    <a href="{{ route('audiencias.index') }}" class="btn btn-warning mt-3">Cancelar</a>
</div>
