@extends('layouts.app')
@section('title', 'Plantilla')
@section('content')
<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body performane-indicator-card">
                <h4 class="card-title">Audiencias Registradas</h4>
                <div class="">
                    <table class="table table-bordered table-hover" width="100%">
                        <thead>
                            <tr>
                                <th class="text-center"></th>
                                <th class="text-center">Departamento</th>
                                <th class="text-center">Proceso</th>
                                <th class="text-center">Partes</th>
                                <th class="text-center">Juzgado</th>
                                <th class="text-center">Sala</th>
                                <th class="text-center">Delito</th>
                                <th class="text-center">Tipo De Audiencia</th>
                                <th class="text-center">Estado</th>
                                <th class="text-center">Fecha Hora</th>
                                <th class="text-center">Abogado</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($audiencias as $audiencia)
                            <tr >
                                <td>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <button id="btnAcciones{{ $audiencia->id }}" type="button" class="btn btn-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                            Acciones
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="btnAcciones{{ $audiencia->id }}">
                                            <li><a class="dropdown-item" href="{{ route('audiencias.show', $audiencia) }}">Ver</a></li>
                                            <li><a class="dropdown-item" href="{{ route('audiencias.edit', $audiencia) }}">Editar</a></li>
                                            <li><a href="{{ route('audiencias.destroy', $audiencia->id) }}" class="dropdown-item" data-confirm-delete="true">Eliminar</a></li>
                                        </ul>
                                    </div>
                                </td>
                                <td class="table-{{ $audiencia->color }}">{{ $audiencia->departamento }}</td>
                                <td class="table-{{ $audiencia->color }}">{{ $audiencia->proceso->codigo_proceso }}</td>
                                <td class="table-{{ $audiencia->color }}">{{ $audiencia->proceso->parte_demandante }}</td>
                                <td class="table-{{ $audiencia->color }}">{{ $audiencia->juzgado }}</td>
                                <td class="table-{{ $audiencia->color }}">{{ $audiencia->sala }}</td>
                                <td class="table-{{ $audiencia->color }}">{{ $audiencia->proceso->delito }}</td>
                                <td class="table-{{ $audiencia->color }}">{{ $audiencia->tipo_audiencia->nombre }}</td>
                                <td class="table-{{ $audiencia->color }}">{{ ucfirst($audiencia->estado->nombre) }}</td>
                                <td class="table-{{ $audiencia->color }}">{{ date('d/m/Y', strtotime($audiencia->fecha_audiencia)) }} - {{ $audiencia->hora_audiencia }} </td>
                                <td class="table-{{ $audiencia->color }}">
                                    @foreach($audiencia->abogados as $abogado)
                                        <span class="badge bg-primary">{{ $abogado->name }}</span>
                                    @endforeach
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    {{ $audiencias->links() }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
@endsection