@extends('layouts.app')
@section('title', 'Calendario de Audiencias')
@section('content')
<style>
    .bg-orange { background-color:#fd7e14; }
    .bg-danger { background-color:#dc3545; }
    .bg-warning { background-color:#ffc107; }
    .bg-primary { background-color:#007bff; }
    .bg-success { background-color:#28a745; }
    .bg-secondary { background-color:#6c757d; }
</style>
    <div class="row ">
        <div class="col-md-12">
            <div class="card ">
                <div class="card-header text-white" style="background-color:#007bff;">
                    <i class="fa fa-gavel"></i> Calendario de Audiencias
                </div>
                <div class="card-body">
                    <div class="text-right">
                        <a href="{{ route('audiencias.export.excel') }}"
                        class="btn btn-success">
                        <i class="fas fa-file-excel"></i> Exportar Excel
                        </a>
                    </div>
                    <div class="mt-1">
                        <span class="badge bg-danger">Hoy</span>
                        <span class="badge bg-warning text-dark">≤ 7 días</span>
                        <span class="badge bg-orange">≤ 3 días</span>
                        <span class="badge bg-primary">Programada</span>
                        <span class="badge bg-success">Concluida</span>
                        <span class="badge bg-secondary">Suspendida</span>
                    </div>

                    <div class="table-responsive">
                        <div id="calendar"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')

    <script>
document.addEventListener('DOMContentLoaded', function() {

    let calendarEl = document.getElementById('calendar');

    let calendar = new FullCalendar.Calendar(calendarEl, {
        locale: 'es',
        initialView: 'dayGridMonth',
        height: 'auto',
        headerToolbar: {
            left: 'prev,next today',
            center: 'title',
            right: 'dayGridMonth,timeGridWeek'
        },
        events: "{{ route('home.audiencias.calendar') }}",
        eventClick: function(info) {
            let e = info.event.extendedProps;

            alert(
                'Proceso: ' + e.proceso + '\n' +
                'Juzgado: ' + e.juzgado + '\n' +
                'Estado: ' + e.estado
            );
        }
    });

    calendar.render();
});
</script>

@endsection