@csrf
@if($errors->any())
    <div class="alert alert-outline-danger">
        <strong>Debe corregir los siguientes errores:</strong>
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
<p>Debe completar todos los campos.</p>
<div class="row">
    <div class="col-md-2">
        <label>Fecha Inicio</label>
        <input type="date" name="fecha_inicio" class="form-control @error('fecha_inicio') is-invalid @enderror" value="{{ old('fecha_inicio',$proceso->fecha_inicio ?? '') }}">
        @error('fecha_inicio')
            <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>
    <div class="col-md-2">
        <label>Número NUREJ</label>
        <input type="text" name="numero_nurej" class="form-control @error('numero_nurej') is-invalid @enderror" value="{{ old('numero_nurej',$proceso->numero_nurej ?? '') }}"  pattern="^\d{4}[-\/]\d+$" title="Formato válido: 2025-14585 o 2025/478412">
        @error('numero_nurej')
            <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>
    
    <div class="col-md-8">
        <label>Parte Demandante</label>
        <input type="text" name="parte_demandante" class="form-control @error('parte_demandante') is-invalid @enderror" value="{{ old('parte_demandante',$proceso->parte_demandante ?? '') }}">
        @error('parte_demandante')
            <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>
</div>
<div class="row mt-2">
    <div class="col-md-12">
        <label>Descripción Proceso</label>
        <textarea name="nombre_proceso" class="form-control @error('nombre_proceso') is-invalid @enderror" id="nombre_proceso" cols="30" rows="10">{{ old('nombre_proceso', $proceso->nombre_proceso ?? '') }}</textarea>
        @error('nombre_proceso')
            <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>
</div>
<div class="row mt-2">
    <div class="col-md-6">
        <label>Delito</label>
            <input type="text" name="delito" class="form-control @error('delito') is-invalid @enderror" value="{{ old('delito',$proceso->delito ?? '') }}">
            @error('delito')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
    </div>
    <div class="col-md-6">
        <label>Tipo Proceso</label>
        <select name="tipo_proceso_id" class="form-control @error('tipo_proceso_id') is-invalid @enderror">
            <option value="">Seleccione un tipo de proceso</option>
            @foreach($tipos_proceso as $tipo)
                <option value="{{ $tipo->id }}" {{ old('tipo_proceso_id', $proceso->tipo_proceso_id ?? '') == $tipo->id ? 'selected' : '' }}>
                    {{ $tipo->nombre }}
                </option>
            @endforeach
        </select>
        @error('tipo_proceso_id')
            <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>
</div>
<div class="text-center">
    <button class="btn btn-success mt-3">Guardar</button>
    <a href="{{ route('procesos.index') }}" class="btn btn-warning mt-3">Cancelar</a>
</div>