@extends('layouts.app')
@section('title', 'Procesos Finalizados')
@section('content')
<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
    <div class="card">
        <div class="card-body performane-indicator-card">
            <h4 class="card-title">Procesos Finalizados</h4>
            <table class="table table-hover">
                <thead>
                <tr>
                    <th class="text-center"></th>
                    <th class="text-center">Fecha Inicio</th>
                    <th class="text-center">Código</th>
                    <th class="text-center">Número Nurej</th>
                    <th class="text-center">Proceso</th>
                    <th class="text-center">Parte Demandante</th>
                    <th class="text-center">Tipo Proceso</th>
                    <th class="text-center">Estado</th>
                </tr>
                </thead>

                <tbody>
                @foreach($procesos as $proceso)
                <tr>
                    <td class="text-center">
                        <div class="btn-group btn-group-sm" role="group">
                            <button id="btnAcciones{{ $proceso->id }}" type="button" class="btn btn-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                Acciones
                            </button>
                            <ul class="dropdown-menu" aria-labelledby="btnAcciones{{ $proceso->id }}">
                                <li>
                                    <a class="dropdown-item" href="#" data-bs-toggle="modal"
                                    data-bs-target="#seguimientoModal"
                                    data-caso="{{ $proceso->id }}"
                                    data-codigo="{{ $proceso->codigo }}">Seguimiento</a>
                                </li>
                                <li><a class="dropdown-item" href="{{ route('procesos.pdf', $proceso) }}">PDF</a></li>
                                <li><a class="dropdown-item" href="{{ route('procesos.edit', $proceso) }}">Editar</a></li>
                                <li><a href="{{ route('procesos.destroy', $proceso->id) }}" class="dropdown-item" data-confirm-delete="true">Eliminar</a>
</li>
                            </ul>
                        </div>
                    </td>
                    <td>{{ date('d/m/Y', strtotime($proceso->fecha_inicio)) }}</td>
                    <td>{{ $proceso->codigo_proceso }}</td>
                    <td>{{ $proceso->numero_nurej }}</td>
                    <td>{{ $proceso->nombre_proceso }}</td>
                    <td>{{ $proceso->parte_demandante }}</td>
                    <td>{{ $proceso->tipo_proceso->nombre }}</td>
                    <td>
                        @if($proceso->seguimientos->isEmpty())
                        <span class="badge bg-secondary">SIN SEGUIMIENTO</span>
                        @else
                        <span class="badge 
                            @if($proceso->seguimientos->last()->estado=='PROGRAMADA') bg-primary
                            @elseif($proceso->seguimientos->last()->estado=='SUSPENDIDA') bg-warning
                            @else bg-success @endif">
                            {{ $proceso->seguimientos->last()->estado }}
                        </span>
                        @endif
                    </td>
                </tr>
                @endforeach
                </tbody>
                </table>

                @include('procesos.modal_seguimiento')
                {{ $procesos->links() }}
        </div>
    </div>
    </div>
</div>
@endsection
@section('scripts')
<script>
const seguimientoModal = document.getElementById('seguimientoModal');

seguimientoModal.addEventListener('show.bs.modal', function (event) {
    const button = event.relatedTarget;

    document.getElementById('caso_id').value =
        button.getAttribute('data-caso');

    document.getElementById('codigoCaso').innerText =
        button.getAttribute('data-codigo');
});
</script>

@endsection