<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">

<style>
    body {
        font-family: Arial, Helvetica, sans-serif;
        font-size: 12px;
    }

    .header {
        width: 100%;
        margin-bottom: 20px;
    }

    .left {
        float: left;
        width: 60%;
    }

    .right {
        float: right;
        width: 40%;
        text-align: right;
    }

    .clear {
        clear: both;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 15px;
    }

    th, td {
        border: 1px solid #000;
        padding: 6px;
        font-size: 11px;
    }

    th {
        background-color: #e9ecef;
        text-align: center;
    }

    .estado {
        font-weight: bold;
    }

    .footer {
        position: fixed;
        bottom: -10px;
        text-align: center;
        font-size: 10px;
        width: 100%;
    }
</style>
</head>

<body>

<!-- ENCABEZADO -->
<div class="header">
    <div class="left">
        <h2>
            <strong>CÓDIGO DEL PROCESO:</strong>N°
            {{ $proceso->codigo_proceso }}
        </h2>
    </div>

    <div class="right">
        <img src="{{ public_path('assets/images/logo.png') }}" width="250">
    </div>
</div>

<div class="clear"></div>
<hr>

<!-- DATOS GENERALES -->
<p><strong>Proceso:</strong> {{ $proceso->nombre_proceso }}</p>
<p><strong>Nurej:</strong> {{ $proceso->numero_nurej }}</p>
<p><strong>Parte demandante:</strong> {{ $proceso->parte_demandante }}</p>
<p><strong>Fecha de registro:</strong> {{ $proceso->created_at->format('d/m/Y') }}</p>

<hr>

<!-- TABLA DE SEGUIMIENTOS -->
<h4>Historial de Seguimiento</h4>

<table>
    <thead>
        <tr>
            <th>#</th>
            <th>Fecha</th>
            <th>Estado</th>
            <th>Observación</th>
            <th>Registrado por</th>
        </tr>
    </thead>

    <tbody>
        @foreach($proceso->seguimientos as $i => $seg)
        <tr>
            <td align="center">{{ $i+1 }}</td>
            <td>{{ date('d/m/Y', strtotime($seg->fecha_seguimiento)) }}</td>
            <td align="center">{{ $seg->estado->nombre }}</td>
            <td>{{ $seg->observacion }}</td>
            <td>{{ $seg->usuario->name ?? '—' }}</td>
        </tr>
        @endforeach
    </tbody>
</table>

<h4>Audiencias Registradas</h4>

<table>
    <thead>
            <th>#</th>
            <th>Fecha</th>
            <th>Hora</th>
            <th>Lugar</th>
            <th>Juzgado</th>
            <th>Sala</th>
            <th>Departamento</th>
            <th>Estado</th>
            <th>Responsable(s)</th>
        </thead>
        <tbody>
            @foreach($proceso->audiencias as $j => $audiencia)
            <tr>
                <td align="center">{{ $j+1 }}</td>
                <td align="center">{{ date('d/m/Y', strtotime($audiencia->fecha_audiencia)) }}</td>
                <td align="center">{{ date('h:i A', strtotime($audiencia->hora_audiencia)) }}</td>
                <td>{{ $audiencia->lugar }}</td>
                <td>{{ $audiencia->juzgado }}</td>
                <td>{{ $audiencia->sala }}</td>
                <td>{{ $audiencia->departamento }}</td>
                <td align="center">{{ $audiencia->estado->nombre }}</td>
                <td>
                    @foreach($audiencia->abogados as $abogado)
                        <span class="badge bg-primary">{{ $abogado->name }}</span>
                    @endforeach
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
<hr>
<div class="footer">
    Documento generado automáticamente — Dirección Jurídica
</div>

</body>
</html>
