<?php

use App\Exports\AudienciasExport;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();
Route::get('sso-login', [App\Http\Controllers\SsoAutenticacionSeguridadController::class, 'autenticacion']);
Route::get('/refresh-captcha', [App\Http\Controllers\Auth\LoginController::class, 'refreshCaptcha'])->name('refresh-captcha');
Route::middleware(['auth'])->group(function(){
    Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
    Route::resource('audiencias', App\Http\Controllers\AudienciaController::class);
    Route::get('/home/audiencias', [HomeController::class, 'audienciasCalendar'])->name('home.audiencias.calendar');
    Route::get('/audiencias/export/excel', function () {
        return Excel::download(new AudienciasExport, 'audiencias_juridicas_al_' . date('Y-m-d') . '.xlsx');
    })->name('audiencias.export.excel');
    //User
    Route::post('users/store',[App\Http\Controllers\UserController::class,'store'])->name('users.store')->middleware('permission:users.create');
    Route::get('users',[App\Http\Controllers\UserController::class,'index'])->name('users.index')->middleware('permission:users.index');
    Route::get('users/create',[App\Http\Controllers\UserController::class,'create'])->name('users.create')->middleware('permission:users.create');
    Route::put('users/{user}',[App\Http\Controllers\UserController::class,'update'])->name('users.update')->middleware('permission:users.edit');
    Route::get('users/{user}',[App\Http\Controllers\UserController::class,'show'])->name('users.show')->middleware('permission:users.show');
    Route::delete('users/{user}',[App\Http\Controllers\UserController::class,'destroy'])->name('users.destroy')->middleware('permission:users.destroy');
    Route::get('users/{user}/edit',[App\Http\Controllers\UserController::class,'edit'])->name('users.edit')->middleware('permission:users.edit');
     
    //Roles
    Route::post('roles/store',[App\Http\Controllers\RoleController::class,'store'])->name('roles.store')->middleware('permission:roles.create');
    Route::get('roles',[App\Http\Controllers\RoleController::class,'index'])->name('roles.index')->middleware('permission:roles.index');
    Route::get('roles/create',[App\Http\Controllers\RoleController::class,'create'])->name('roles.create')->middleware('permission:roles.create');
    Route::put('roles/{role}',[App\Http\Controllers\RoleController::class,'update'])->name('roles.update')->middleware('permission:roles.edit');
    Route::get('roles/{role}',[App\Http\Controllers\RoleController::class,'show'])->name('roles.show')->middleware('permission:roles.show');
    Route::delete('roles/{role}',[App\Http\Controllers\RoleController::class,'destroy'])->name('roles.destroy')->middleware('permission:roles.destroy');
    Route::get('roles/{role}/edit',[App\Http\Controllers\RoleController::class,'edit'])->name('roles.edit')->middleware('permission:roles.edit');

    // Route::resource('casos', App\Http\Controllers\CasoController::class);

    //Casos
    Route::post('procesos/store',[App\Http\Controllers\ProcesoController::class,'store'])->name('procesos.store')->middleware('permission:procesos.create');
    Route::get('procesos-judiciales',[App\Http\Controllers\ProcesoController::class,'index'])->name('procesos.index')->middleware('permission:procesos.index');
    Route::get('nuevo-proceso',[App\Http\Controllers\ProcesoController::class,'create'])->name('procesos.create')->middleware('permission:procesos.create');
    Route::put('procesos/{proceso}',[App\Http\Controllers\ProcesoController::class,'update'])->name('procesos.update')->middleware('permission:procesos.edit');
    Route::get('procesos/{proceso}',[App\Http\Controllers\ProcesoController::class,'show'])->name('procesos.show')->middleware('permission:procesos.show');
    Route::delete('procesos/{proceso}',[App\Http\Controllers\ProcesoController::class,'destroy'])->name('procesos.destroy')->middleware('permission:procesos.destroy');
    Route::get('procesos/{proceso}/edit',[App\Http\Controllers\ProcesoController::class,'edit'])->name('procesos.edit')->middleware('permission:procesos.edit');
    Route::get('datos-proceso', [App\Http\Controllers\ProcesoController::class, 'datos_proceso'])->name('datos_proceso');

    Route::post('seguimientos/store', [App\Http\Controllers\SeguimientoController::class,'store'])->name('seguimientos.store')->middleware('permission:seguimientos.create');
    Route::get('seguimientos', [App\Http\Controllers\SeguimientoController::class,'index'])->name('seguimientos.index')->middleware('permission:seguimientos.index');
    Route::get('seguimientos/create/{proceso}',[App\Http\Controllers\SeguimientoController::class,'create'])->name('seguimientos.create')->middleware('permission:seguimientos.create');
    Route::get('ver-adjuntos-seguimiento/{proceso}',[App\Http\Controllers\SeguimientoController::class,'ver_adjuntos'])->name('seguimientos.ver_adjuntos')->middleware('permission:seguimientos.create');
    Route::delete('seguimientos/{seguimiento}',[App\Http\Controllers\SeguimientoController::class,'destroy'])->name('seguimientos.destroy')->middleware('permission:seguimientos.destroy');
    Route::get('seguimientos/{seguimiento}/edit',[App\Http\Controllers\SeguimientoController::class,'edit'])->name('seguimientos.edit')->middleware('permission:seguimientos.edit');
    Route::get('procesos/{proceso}/pdf', [App\Http\Controllers\ProcesoController::class, 'pdf'])->name('procesos.pdf');
    Route::get('procesos-finalizados', [App\Http\Controllers\ProcesoController::class, 'procesos_finalizados'])->name('procesos.finalizados');

});
