<?php

namespace Tests\Feature;

use Carbon\Carbon;
use Tests\TestCase;
use App\Models\Proceso;
use App\Models\Parametro;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Foundation\Testing\RefreshDatabase;

class ProcesoTest extends TestCase
{
    use RefreshDatabase;
    
    public function test_genera_codigo_y_numero_proceso_automaticamente()
    {
        // Arrange (preparar datos)
        $tipo = Parametro::factory()->create([
            'codigo' => 'CIV'
        ]);

        $fecha = Carbon::create(2025, 3, 15);

        // Act (ejecutar)
        $proceso = Proceso::create([
            'numero_nurej'     => 'NUREJ-001',
            'parte_demandante' => 'Juan Pérez',
            'nombre_proceso'   => 'Proceso de prueba',
            'tipo_proceso_id'  => $tipo->id,
            'fecha_inicio'     => $fecha,
        ]);

        // Assert (verificar)
        $this->assertNotNull($proceso->numero_proceso);
        $this->assertEquals(1, $proceso->numero_proceso);

        $this->assertEquals(
            'SEDEM/GJ/CIV/2025-001',
            $proceso->codigo_proceso
        );
    }

    public function test_incrementa_numero_proceso_por_gestion()
    {
        $tipo = Parametro::factory()->create([
            'codigo' => 'CIV'
        ]);

        $fecha = '2025-01-01';

        Proceso::factory()->create([
            'fecha_inicio'    => $fecha,
            'tipo_proceso_id' => $tipo->id,
            'numero_proceso'  => 1,
        ]);

        $nuevo = Proceso::create([
            'numero_nurej'     => 'NUREJ-002',
            'parte_demandante' => 'Ana López',
            'nombre_proceso'   => 'Segundo proceso',
            'tipo_proceso_id'  => $tipo->id,
            'fecha_inicio'     => $fecha,
        ]);

        $this->assertEquals(2, $nuevo->numero_proceso);
        $this->assertEquals(
            'SEDEM/GJ/CIV/2025-002',
            $nuevo->codigo_proceso
        );
    }

}
